<?php

declare(strict_types=1);

namespace Bridge\Database\Seeders;

use Bridge\Domains\Member\Member;
use Bridge\Domains\Supplier\Supplier;
use Illuminate\Database\Seeder;

class DatabaseSeeder extends Seeder
{
    public function run(): void
    {
        if (app()->isProduction()) {
            return;
        }

        Member::factory()->staff()->create([
            'name' => 'Admin',
            'nickname' => null,
            'email' => 'dev@tontri.com',
        ]);

        Member::factory()->customer()->create([
            'name' => 'Tridip',
            'nickname' => null,
            'email' => 'tridip@tontri.com',
        ]);

        Member::factory()->staff()->create([
            'name' => 'System',
            'nickname' => null,
            'email' => 'system@billing.tld',
        ]);

        if (!app()->runningUnitTests()) {
            Supplier::query()->create([
                'name' => 'JuicyCodes',
                'email' => 'contact@juicycodes.com',
                'country' => 'us',
                'nickname' => 'JUICYCODES',
                'website' => 'https://juicycodes.com',
                'note' => null,
                'address' => null,
            ]);

            $this->call([
                CurrencySeeder::class,
                ItemSeeder::class,
            ]);

            Member::factory()->staff()->count(2)->create();
            Member::factory()->customer()->count(3)->create();
        }
    }
}
