<?php

declare(strict_types=1);

namespace Bridge\Database\Seeders;

use Bridge\Domains\Currency\Currency;
use Illuminate\Database\Seeder;

class CurrencySeeder extends Seeder
{
    public function run(): void
    {
        Currency::query()->create([
            'name' => 'US Dollar',
            'code' => 'USD',
            'symbol' => '$',
            'rate' => 1,
        ]);

        Currency::query()->create([
            'name' => 'Bangladeshi Taka',
            'code' => 'BDT',
            'symbol' => '৳',
            'rate' => 115,
        ]);

        Currency::query()->create([
            'name' => 'UAE Dirham',
            'code' => 'AED',
            'symbol' => 'AED',
            'rate' => 3.65,
        ]);
    }
}
