<?php

declare(strict_types=1);

use Bridge\Domains\Invoice\Models\Invoice;
use Bridge\Domains\Member\Enums\MemberType;
use Bridge\Domains\Member\Member;
use Bridge\Domains\Ticket\Enums\TicketCreator;
use Bridge\Domains\Ticket\Enums\TicketStatus;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('tickets', function (Blueprint $table) {
            $table->id();
            $table->string('number', 15)->unique();
            $table->string('subject');
            $table->enum('status', TicketStatus::options())->index();
            $table->enum('created_by', TicketCreator::options())->index();
            $table->enum('last_reply_from', MemberType::options())->index();

            $table->foreignId('assigned_to')
                ->nullable()
                ->constrained(Member::table())
                ->restrictOnDelete();

            $table->foreignId('customer_id')
                ->constrained(Member::table())
                ->restrictOnDelete();

            $table->foreignIdFor(Invoice::class)
                ->nullable()
                ->constrained()
                ->restrictOnDelete();

            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('tickets');
    }
};
