<?php

declare(strict_types=1);

use Bridge\Domains\Currency\Currency;
use Bridge\Domains\Discount\Enums\DiscountType;
use Bridge\Domains\Invoice\Models\Invoice;
use Bridge\Domains\Item\Models\Item;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('invoice_items', function (Blueprint $table) {
            $table->id();
            $table->foreignIdFor(Invoice::class)
                ->constrained()
                ->restrictOnUpdate()
                ->restrictOnDelete();

            $table->foreignIdFor(Item::class)
                ->constrained()
                ->restrictOnUpdate()
                ->restrictOnDelete();

            $table->unsignedInteger('quantity')->default(1);
            $table->decimal('price', 10);
            $table->decimal('discount', 10);

            $table->foreignIdFor(Currency::class)
                ->constrained()
                ->restrictOnUpdate()
                ->restrictOnDelete();

            $table->decimal('currency_rate', 10, 4)
                ->default(1);

            $table->enum('discount_type', DiscountType::options())->nullable();
            $table->decimal('discount_amount', 10)->nullable();

            $table->string('description', 100)->nullable();
            $table->unsignedTinyInteger('order')->default(0);

            $table->timestamps();
            $table->softDeletes();

            $table->unique(['invoice_id', 'item_id']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('invoice_items');
    }
};
