<?php

declare(strict_types=1);

use Bridge\Domains\Currency\Currency;
use Bridge\Domains\Discount\Models\Discount;
use Bridge\Domains\Invoice\Enums\InvoiceStatus;
use Bridge\Domains\Invoice\Enums\InvoiceType;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('invoices', function (Blueprint $table) {
            $table->id();
            $table->string('number', 10)->unique();
            $table->date('issued_on');
            $table->date('due_on');
            $table->enum('type', InvoiceType::options());
            $table->enum('status', InvoiceStatus::options());

            $table->morphs('contact');
            $table->foreignIdFor(Currency::class)
                ->constrained()
                ->restrictOnUpdate()
                ->restrictOnDelete();

            $table->decimal('currency_rate', 10, 4);
            $table->decimal('total', 10);
            $table->decimal('subtotal', 10);
            $table->decimal('fee', 10)->default(0);
            $table->foreignIdFor(Discount::class)
                ->nullable()
                ->constrained()
                ->restrictOnUpdate()
                ->restrictOnDelete();

            $table->string('notes', 100)->nullable();

            $table->nullableMorphs('generator');

            $table->timestamps();
            $table->softDeletes();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('invoices');
    }
};
