<?php

declare(strict_types=1);

use Bridge\Domains\Currency\Currency;
use Bridge\Domains\Item\Models\Item;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        $currencyTable = Currency::table();

        Schema::create('item_prices', function (Blueprint $table) use ($currencyTable) {
            $table->id();
            $table->foreignIdFor(Item::class)
                ->unique()
                ->constrained()
                ->restrictOnUpdate()
                ->restrictOnDelete();

            $table->decimal('buy_for', 10);
            $table->foreignId('buy_currency_id')
                ->constrained($currencyTable)
                ->restrictOnUpdate()
                ->restrictOnDelete();

            $table->decimal('sell_for', 10);
            $table->foreignId('sell_currency_id')
                ->constrained($currencyTable)
                ->restrictOnUpdate()
                ->restrictOnDelete();

            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('item_prices');
    }
};
