<?php

declare(strict_types=1);

namespace Bridge\Database\Factories;

use Bridge\Domains\Invoice\Models\Invoice;
use Bridge\Domains\Member\Enums\MemberType;
use Bridge\Domains\Member\Member;
use Bridge\Domains\Ticket\Enums\TicketCreator;
use Bridge\Domains\Ticket\Enums\TicketStatus;
use Bridge\Domains\Ticket\Models\Ticket;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<Ticket>
 */
class TicketFactory extends Factory
{
    protected $model = Ticket::class;

    /**
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'subject' => fake()->sentence,
            'status' => fake()->randomElement(TicketStatus::options()),
            'created_by' => fake()->randomElement(TicketCreator::options()),
            'last_reply_from' => fake()->randomElement(MemberType::options()),
            'customer_id' => Member::query()->isCustomer()->inRandomOrder()->value('id'),
            'invoice_id' => fake()->boolean(40) ? null : Invoice::query()->inRandomOrder()->value('id'),
            'assigned_to' => fake()->boolean(40) ? null : Member::query()->isStaff()->inRandomOrder()->value('id'),
        ];
    }
}
