<?php

declare(strict_types=1);

namespace Bridge\Database\Factories;

use Bridge\Domains\Supplier\Supplier;
use Bridge\Support\Country;
use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Arr;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<Supplier>
 */
class SupplierFactory extends Factory
{
    protected $model = Supplier::class;

    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'note' => null,
            'name' => fake()->company(),
            'website' => $this->getRandomWebsite(),
            'email' => fake()->unique()->safeEmail(),
            'country' => Arr::random(Country::codes()),
            'address' => fake()->optional(0.8)->address(),
            'nickname' => $this->getNickname(),
        ];
    }

    private function getRandomWebsite(): ?string
    {
        return fake()->boolean()
            ? null
            : 'https://'.$this->faker->domainName();
    }

    private function getNickname(): ?string
    {
        return fake()->boolean()
            ? null
            : strtoupper(fake()->domainWord());
    }
}
