<?php

declare(strict_types=1);

namespace Bridge\Database\Factories;

use Bridge\Domains\Item\Enums\ItemType;
use Bridge\Domains\Product\Product;
use Bridge\Domains\Product\ProductType;
use Illuminate\Support\Str;

/**
 * @extends ItemFactory<Product>
 */
class ProductFactory extends ItemFactory
{
    protected $model = Product::class;

    /**
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            ...parent::definition(),
            'type' => ItemType::Product->value,
        ];
    }

    public function metaData(): array
    {
        return [
            'type' => ProductType::Generic->value,
            'codename' => $this->generateCodename(),
            'short_name' => fake()->unique()->regexify('[A-Z]{3}'),
        ];
    }

    private function generateCodename(): string
    {
        /** @var string $words */
        $words = fake()->unique()->words(20, asText: true);

        return Str::of($words)
            ->substr(0, rand(10, 20))
            ->replace(' ', '_')
            ->lower()
            ->toString();
    }
}
