<?php

declare(strict_types=1);

namespace Bridge\Database\Factories;

use Bridge\Domains\Discount\Enums\DiscountType;
use Bridge\Domains\Discount\Models\Discount;
use Bridge\Domains\Discount\Models\DiscountItem;
use Bridge\Domains\Item\Models\Item;
use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Arr;

/**
 * @extends Factory<DiscountItem>
 */
class DiscountItemFactory extends Factory
{
    protected $model = DiscountItem::class;

    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        /** @var DiscountType $type */
        $type = Arr::random(DiscountType::cases());

        return [
            'type' => $type,
            'item_id' => Item::factory(),
            'discount_id' => Discount::factory(),
            'amount' => match ($type) {
                DiscountType::Fixed => $this->faker->randomFloat(2, 1, 99),
                DiscountType::Percentage => $this->faker->randomFloat(2, 1, 999),
            },
        ];
    }
}
