<?php

declare(strict_types=1);

namespace Bridge\Support\Pagination;

use Bridge\Support\MaskedId\MaskedId;
use Illuminate\Database\Eloquent\Model;

class FilterParams
{
    /**
     * @var array<string, class-string<Model>>
     */
    protected static array $idModels = [];

    /**
     * @return null|array<string, string|string[]>
     */
    public static function transformed(): ?array
    {
        $filters = request()->query('filter');

        if (!is_array($filters)) {
            return null;
        }

        return collect($filters)
            ->map(function ($value, string $key) {
                if ($key === 'search') {
                    return $value;
                }

                if (MaskedId::canBeEncoded($value, $key)) {
                    return app(MaskedId::class)
                        ->encodeModelId(self::getModelForId($key), $value);
                }

                return explode(',', (string) $value);
            })
            ->toArray();
    }

    /**
     * @param  array<string, class-string<Model>>  $idModels
     */
    public static function setIdModels(array $idModels): void
    {
        self::$idModels = array_merge(self::$idModels, $idModels);
    }

    /**
     * @return class-string<Model>
     */
    protected static function getModelForId(string $id): string
    {
        return self::$idModels[$id] ?? Model::class;
    }
}
