<?php

declare(strict_types=1);

namespace Bridge\Support;

use Bridge\Support\MaskedId\HasMaskedId;
use Spatie\Activitylog\LogOptions;
use Spatie\Activitylog\Traits\LogsActivity;

trait ModelTraits
{
    use HasMaskedId;
    use LogsActivity;

    public static function table(): string
    {
        /** @phpstan-ignore-next-line */
        return (new static())->getTable();
    }

    public function getActivitylogOptions(): LogOptions
    {
        return LogOptions::defaults()
            ->logAll()
            ->logOnlyDirty();
    }
}
