<?php

declare(strict_types=1);

namespace Bridge\Support\MaskedId;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Arr;
use Jenssegers\Optimus\Optimus;

class MaskedId
{
    public function __construct(
        protected Optimus $optimus,
    ) {}

    /**
     * @param  class-string<Model>  $model
     */
    public function encodeModelId(string $model, int|string $id): int
    {
        // $uniqish = $this->convertModelToNumber($model);

        // return $this->optimus->encode(intval($uniqish.$id));

        return $this->optimus->encode(intval($id));
    }

    public function decodeModelId(int|string $value): int
    {
        return $this->optimus->decode((int) $value);

        // return (int) substr((string) $decoded, 4);
    }

    /**
     * @param  array<int|string>  $values
     * @return array<int>
     */
    public function decodeModelIds(array $values): array
    {
        return Arr::map($values, $this->decodeModelId(...));
    }

    public static function canBeEncoded(mixed $value, ?string $key = null): bool
    {
        if ($key !== null && !str_ends_with($key, '_id')) {
            return false;
        }

        return is_int($value) || ctype_digit($value);
    }

    public static function canBeDecoded(mixed $value, ?string $key = null): bool
    {
        if ($key !== null && !str_ends_with($key, '_id')) {
            return false;
        }

        // Value can be an int or a string that contains an int
        return is_int($value) || ctype_digit($value);
    }

    private function convertModelToNumber(string $model): int
    {
        $length = strlen($model);
        $sumOfOrd = array_reduce(str_split($model), function ($carry, $item) {
            return $carry + ord($item);
        }, 0);

        return (int) str_pad((string) ($sumOfOrd + $length), 6, '0');
    }
}
