<?php

declare(strict_types=1);

namespace Bridge\Support;

use Spatie\DiscordAlerts\Facades\DiscordAlert as SpatieDiscord;

class DiscordAlert
{
    public static function send(string $title, string $description): void
    {
        SpatieDiscord::message('', [
            [
                'color' => '#ff7900',
                ...compact('title', 'description'),
            ],
        ]);
    }
}
