<?php

declare(strict_types=1);

namespace Bridge\Support\Casts;

use Brick\Math\BigDecimal;
use Brick\Math\BigNumber;
use Brick\Math\RoundingMode;
use Illuminate\Contracts\Database\Eloquent\CastsAttributes;
use Illuminate\Database\Eloquent\Model;

/**
 * @implements CastsAttributes<float,float>
 */
class Amount implements CastsAttributes
{
    protected static int $decimals = 2;

    public function __construct(?string $decimals = null)
    {
        if ($decimals !== null) {
            self::$decimals = (int) $decimals;
        }
    }

    /**
     * @param  array<string, mixed>  $attributes
     */
    public function get(Model $model, string $key, mixed $value, array $attributes): float
    {
        return self::round($value);
    }

    /**
     * @param  array<string, mixed>  $attributes
     */
    public function set(Model $model, string $key, mixed $value, array $attributes): float
    {
        return self::round($value);
    }

    public static function round(mixed $value): float
    {
        return (float) bcdiv((string) $value, '1', self::$decimals);
    }

    public static function bigDecimal(BigNumber|int|float|string $value, int $scale = 4): BigDecimal
    {
        return BigDecimal::of($value)->toScale($scale, RoundingMode::UP);
    }
}
