<?php

declare(strict_types=1);

namespace Bridge\Domains\Ticket\Models;

use Bridge\Database\Factories\TicketReplyFactory;
use Bridge\Domains\Member\Member;
use Bridge\Support\ModelTraits;
use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class TicketReply extends Model
{
    use HasFactory;
    use ModelTraits;

    protected static function booted(): void
    {
        static::creating(function (TicketReply $record): void {
            if (!isset($record->order)) {
                $record->order = $record->nextReplyOrder();
            }
        });
    }

    /**
     * @return BelongsTo<Ticket, TicketReply>
     */
    public function ticket(): BelongsTo
    {
        return $this->belongsTo(Ticket::class);
    }

    /**
     * @return BelongsTo<Member, TicketReply>
     */
    public function author(): BelongsTo
    {
        return $this->belongsTo(Member::class, 'author_id');
    }

    /**
     * @return Factory<TicketReply>
     */
    protected static function newFactory(): Factory
    {
        return TicketReplyFactory::new();
    }

    public function nextReplyOrder(): int
    {
        $maxOrder = static::query()->where('ticket_id', $this->ticket_id)->max('order');

        return ($maxOrder ?? -1) + 1;
    }
}
