<?php

declare(strict_types=1);

namespace Bridge\Domains\Ticket\Data;

use Bridge\Domains\Ticket\Models\TicketReply;
use Bridge\Support\Data\DataWithMaskedId;
use League\CommonMark\Environment\Environment;
use League\CommonMark\Extension\Autolink\AutolinkExtension;
use League\CommonMark\Extension\CommonMark\CommonMarkCoreExtension;
use League\CommonMark\Extension\DisallowedRawHtml\DisallowedRawHtmlExtension;
use League\CommonMark\Extension\Strikethrough\StrikethroughExtension;
use League\CommonMark\MarkdownConverter;

class TicketReplyData extends DataWithMaskedId
{
    public function __construct(
        readonly public string $body,

        readonly public TicketReplyAuthorData $author,

        readonly public string $timeDifference,
    ) {}

    public static function fromModel(TicketReply $record): self
    {
        return self::from([
            'author' => $record->author,
            'body' => self::markdown($record->body),
            'timeDifference' => $record->created_at?->diffForHumans() ?? '',
        ]);
    }

    protected static function markdown(string $string): string
    {
        $environment = new Environment();
        $environment->addExtension(new CommonMarkCoreExtension());
        $environment->addExtension(new AutolinkExtension());
        $environment->addExtension(new StrikethroughExtension());
        $environment->addExtension(new DisallowedRawHtmlExtension());

        return (string) (new MarkdownConverter($environment))->convert($string);
    }
}
