<?php

declare(strict_types=1);

namespace Bridge\Domains\Server\Support;

use Bridge\Domains\Server\Data\ServerCredentialData;
use Illuminate\Database\Eloquent\Casts\Json;
use Illuminate\Encryption\Encrypter;
use Illuminate\Support\Collection;

readonly class CredentialEncrypter
{
    protected Encrypter $encrypter;

    public function __construct(string $key, string $cipher = 'AES-256-CBC')
    {
        $this->encrypter = new Encrypter($key, $cipher);
    }

    /**
     * @param  list<mixed[]>|Collection<int,ServerCredentialData>  $data
     */
    public function encrypt(array|Collection $data): string
    {
        if (is_array($data)) {
            $data = ServerCredentialData::collect($data, Collection::class);
        }

        return $this->encrypter->encrypt($data->toJson());
    }

    /**
     * @return Collection<int,ServerCredentialData>
     */
    public function decrypt(string $data): Collection
    {
        /** @var list<array<string,string|null>> $credentials */
        $credentials = Json::decode($this->encrypter->decrypt($data));

        return ServerCredentialData::collect($credentials, Collection::class);
    }
}
