<?php

declare(strict_types=1);

namespace Bridge\Domains\Notification\Staff;

use Bridge\Domains\Ticket\Models\Ticket;
use Bridge\Support\DiscordAlert;

class AlertStaff
{
    public static function newTicketCreated(Ticket $record): void
    {
        DiscordAlert::send(
            title: 'A new support ticket was opened.',
            description: "[#{$record->number}] {$record->subject}"
        );
    }

    public static function userRepliedToTicket(Ticket $record): void
    {
        DiscordAlert::send(
            title: 'User replied to a support ticket.',
            description: "[#{$record->number}] {$record->subject}"
        );
    }
}
