<?php

declare(strict_types=1);

namespace Bridge\Domains\Notification;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\MorphTo;

class Notification extends Model
{
    protected $casts = [
        'should_send' => 'bool',
        'event' => NotificationEvent::class,
    ];

    public function model(): MorphTo
    {
        return $this->morphTo();
    }
}
