<?php

declare(strict_types=1);

namespace Bridge\Domains\Notification;

use Illuminate\Database\Eloquent\Relations\MorphMany;

trait HasNotifications
{
    public function notifications(): MorphMany
    {
        return $this->morphMany(Notification::class, 'model');
    }

    public function notify(NotificationEvent $event, bool $shouldSend = true): void
    {
        $this->notifications()->create([
            'event' => $event,
            'should_send' => $shouldSend,
        ]);
    }

    public function notificationSent(NotificationEvent $event): void
    {
        $this->notifications()->where('event', $event)->update(['sent_at' => now()]);
    }
}
