<?php

declare(strict_types=1);

namespace Bridge\Domains\Notification\Customer\Ticket;

use Bridge\Domains\Ticket\Models\Ticket;
use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Address;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;

class TicketCreated extends Mailable
{
    use Queueable, SerializesModels;

    public function __construct(public Ticket $ticket)
    {
        $this->afterCommit();
        $this->ticket->loadMissing('customer');
    }

    public function envelope(): Envelope
    {
        return new Envelope(
            to: [
                new Address(
                    address: $this->ticket->customer->email,
                    name: $this->ticket->customer->name,
                ),
            ],
            subject: "[#{$this->ticket->number}] {$this->ticket->subject}",
        );
    }

    public function content(): Content
    {
        return new Content(
            markdown: 'bridge::mails.customer.ticket.created',
            with: [
                'url' => route('tickets.conversation', $this->ticket),
            ]
        );
    }
}
