<?php

declare(strict_types=1);

namespace Bridge\Domains\Notification\Customer\Invoice;

use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;

class Invoice7DaysReminder extends InvoiceCreated
{
    public function envelope(): Envelope
    {
        return parent::envelope()->subject("[#{$this->record->number}] Payment Due in 7 Days");
    }

    public function content(): Content
    {
        return parent::content()->markdown('bridge::mails.customer.invoice.reminder');
    }
}
