<?php

declare(strict_types=1);

namespace Bridge\Domains\Member\Support;

use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\Http;

trait HasAvatar
{
    public function getAvatarLink(): string
    {
        return $this->hasGravatar()
            ? $this->getGravatarLink()
            : $this->getDiceBearAvatar();
    }

    protected function hasGravatar(): bool
    {
        if (app()->environment('testing')) {
            return false;
        }

        $cacheKey = sprintf('avatar-%s', md5($this->email));

        return Cache::remember($cacheKey, now()->addDays(7), function () {
            try {
                return Http::head($this->getGravatarLink())->status() === 200;
            } catch (\Throwable) {
                return false;
            }
        });
    }

    protected function getGravatarLink(): string
    {
        $id = md5(strtolower(trim($this->email)));

        return "https://www.gravatar.com/avatar/{$id}?d=404";
    }

    private function getDiceBearAvatar(): string
    {
        $seed = hash('xxh3', $this->email);

        return "https://api.dicebear.com/6.x/bottts/svg?scale=90&seed={$seed}";
    }
}
