<?php

declare(strict_types=1);

namespace Bridge\Domains\Member\Models;

use Bridge\Domains\Item\Models\Item;
use Bridge\Support\ModelTraits;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class MemberItem extends Model
{
    use ModelTraits;

    /**
     * @return BelongsTo<Item,MemberItem>
     */
    public function item(): BelongsTo
    {
        return $this->belongsTo(Item::class);
    }
}
