<?php

declare(strict_types=1);

namespace Bridge\Domains\License\Support;

use Bridge\Domains\License\Models\License;
use Illuminate\Support\Str;
use Random\RandomException;

class GenerateLicenseKey
{
    /**
     * @throws RandomException
     */
    public static function unique(): string
    {
        do {
            $key = self::randomLicenseKey();
        } while (License::query()->withTrashed()->where('key', $key)->exists());

        return $key;
    }

    /**
     * @throws RandomException
     */
    private static function randomLicenseKey(): string
    {
        $license = null;
        $template = str_split('XXXXX-XXXXXX-XXXXX-XXXXXX');
        $characters = str_split(self::getPermittedCharacters());

        foreach ($template as $part) {
            $license .= ($part === '-' ? '-' : $characters[array_rand($characters)]);
        }

        return $license;
    }

    /**
     * @throws RandomException
     */
    private static function getPermittedCharacters(): string
    {
        $characters = implode('', [
            random_int(1000, 9999),
            'ABCDEFGHIJKLMNOPQRSTUVWXYZ',
            hash('xxh128', random_bytes(10)),
        ]);

        return str_shuffle(Str::upper($characters));
    }
}
