<?php

declare(strict_types=1);

namespace Bridge\Domains\License\Models;

use Bridge\Domains\Invoice\Models\Invoice;
use Bridge\Domains\ProductVersion\ProductVersion;
use Bridge\Support\ModelTraits;
use Illuminate\Database\Eloquent\Casts\Attribute;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

/**
 * @property int $product_id
 * @property int $invoice_id
 * @property-read  Product $product
 */
class LicenseProduct extends Model
{
    use ModelTraits;

    protected $connection = 'license_mysql';

    /**
     * @return BelongsTo<License,LicenseProduct>
     */
    public function license(): BelongsTo
    {
        return $this->belongsTo(License::class);
    }

    /**
     * @return BelongsTo<Product,LicenseProduct>
     */
    public function product(): BelongsTo
    {
        return $this->belongsTo(Product::class);
    }

    /**
     * @return BelongsTo<ProductVersion,LicenseProduct>
     */
    public function version(): BelongsTo
    {
        return $this->belongsTo(ProductVersion::class, 'product_version_id');
    }

    /**
     * @return BelongsTo<ProductVersion,LicenseProduct>
     */
    public function liveVersion(): BelongsTo
    {
        return $this->belongsTo(ProductVersion::class, 'live_version_id');
    }

    /**
     * @return Attribute<int,never>
     */
    public function invoiceNumber(): Attribute
    {
        return Attribute::get(fn () => Invoice::query()->where('id', $this->invoice_id)->value('number'));
    }
}
