<?php

declare(strict_types=1);

namespace Bridge\Domains\Invoice\Tasks;

use Bridge\Domains\Invoice\Enums\InvoiceStatus;
use Bridge\Domains\Invoice\Models\Invoice;

class MarkInvoiceAsPending extends AbstractTask
{
    protected static function handle(Invoice $invoice): void
    {
        // Mark the invoice as pending
        $invoice->status = InvoiceStatus::Pending;
        $invoice->save();

        // Clear all licenses associated with this invoice
        self::cleanupItemLicenses($invoice);

        // Clear all item ownership associated with this invoice
        self::cleanupItemOwnership($invoice);
    }
}
