<?php

declare(strict_types=1);

namespace Bridge\Domains\Invoice\Enums;

use ArchTech\Enums\Values;
use Spatie\TypeScriptTransformer\Attributes\TypeScript;

#[TypeScript]
enum PaymentGateway: string
{
    use Values;

    case Wise = 'wise';
    case Card = 'card';
    case PayPal = 'paypal';
    case Cryptocurrency = 'cryptocurrency';

    public function isManual(): bool
    {
        return $this !== self::Cryptocurrency;
    }

    public function label(): string
    {
        return match ($this) {
            self::Wise => 'Wise',
            self::PayPal => 'PayPal',
            self::Card => 'Credit/Debit Card',
            self::Cryptocurrency => 'Cryptocurrency',
        };
    }
}
