<?php

declare(strict_types=1);

namespace Bridge\Domains\Invoice\Enums;

use Bridge\Domains\Invoice\Models\Invoice;
use Bridge\Domains\Server\Models\Server;
use Illuminate\Database\Eloquent\Model;

enum InvoiceGeneratorType: string
{
    case Server = 'server';
    case Invoice = 'invoice';

    /**
     * @param  class-string<Model>  $model
     */
    public static function fromModel(string $model): self
    {
        return match (true) {
            $model === Server::class => self::Server,
            is_a($model, Invoice::class, true) => self::Invoice,
            default => throw new \Exception('Invalid model for InvoiceGeneratorType'),
        };
    }
}
