<?php

declare(strict_types=1);

namespace Bridge\Domains\Invoice\Enums;

use Bridge\Domains\Supplier\Supplier;
use Illuminate\Database\Eloquent\Model;

enum InvoiceContactType: string
{
    case Customer = 'customer';
    case Supplier = 'supplier';

    /**
     * @param  class-string<Model>  $model
     */
    public static function fromModel(string $model): self
    {
        return $model === Supplier::class ? self::Supplier : self::Customer;
    }

    public static function fromInvoiceType(InvoiceType $type): self
    {
        return $type->isSale() ? self::Customer : self::Supplier;
    }
}
