<?php

declare(strict_types=1);

namespace Bridge\Domains\Invoice\Data;

use Bridge\Domains\Discount\Enums\DiscountType;
use Bridge\Support\Data\Data;

class InvoiceItemData extends Data
{
    public function __construct(
        readonly public int $order,
        readonly public int $quantity,

        readonly public float $price,
        readonly public float $discount,
        readonly public ?string $description,

        readonly public int $item_id,
        readonly public int $currency_id,
        readonly public float $currency_rate,

        readonly public ?float $discount_amount,
        readonly public ?DiscountType $discount_type,
    ) {}

    public function subtotal(): float
    {
        return $this->price * $this->quantity;
    }
}
