<?php

declare(strict_types=1);

namespace Bridge\Domains\Bookkeeping\Enums;

use ArchTech\Enums\Options;
use Spatie\TypeScriptTransformer\Attributes\TypeScript;

#[TypeScript]
enum TransactionEntity: string
{
    use Options;

    case Company = 'company';
    case IstiakTridip = 'istiak_tridip';
    case TonmoyAjize = 'tonmoy_ajize';

    public function name(): string
    {
        return match ($this) {
            self::Company => 'Company',
            self::TonmoyAjize => 'Tonmoy Ajize',
            self::IstiakTridip => 'Istiak Tridip',
        };
    }

    public function nickname(): string
    {
        return match ($this) {
            self::Company => 'Company',
            self::TonmoyAjize => 'Tonmoy',
            self::IstiakTridip => 'Tridip',
        };
    }
}
