<?php

declare(strict_types=1);

namespace Bridge\Database\Seeders\Items;

use Bridge\Domains\Currency\Currency;
use Bridge\Domains\Item\Enums\ItemStatus;
use Bridge\Domains\Item\Enums\ItemType;
use Bridge\Domains\Item\Models\Item;
use Bridge\Domains\Product\ProductType;
use Bridge\Domains\Supplier\Supplier;
use Illuminate\Database\Seeder;

class ProductSeeder extends Seeder
{
    public function run(): void
    {
        $supplierId = Supplier::query()->value('id');

        $this->seedVideoStreamingSoftware($supplierId);
        $this->seedLeecherUploadSoon($supplierId);
    }

    private function seedVideoStreamingSoftware(int $supplierId): void
    {
        $item = Item::query()->create([
            'name' => 'Video Streaming Software',
            'supplier_id' => $supplierId,
            'type' => ItemType::Product,
            'status' => ItemStatus::Active,
        ]);

        $item->setMetaData([
            'type' => ProductType::Core,
            'short_name' => 'VSS',
            'codename' => 'video_streaming_software',
            'repository' => 'tontritech/vss-core_readonly',
        ]);

        $item->price()->create([
            'sell_for' => 350,
            'sell_currency_id' => Currency::defaultCurrency()->id,

            'buy_for' => 0,
            'buy_currency_id' => Currency::defaultCurrency()->id,
        ]);
    }

    private function seedLeecherUploadSoon(int $supplierId): void
    {
        $item = Item::query()->create([
            'name' => 'VSS Leecher Upload',
            'supplier_id' => $supplierId,
            'type' => ItemType::Product,
            'status' => ItemStatus::Active,
        ]);

        $item->setMetaData([
            'type' => ProductType::Addon,
            'short_name' => 'VSS-LEECHER',
            'codename' => 'plugin:vss:leecher_api',
            'repository' => 'tontritech/vss-plugin__leecher-api',
        ]);

        $item->price()->create([
            'sell_for' => 100,
            'sell_currency_id' => Currency::defaultCurrency()->id,

            'buy_for' => 0,
            'buy_currency_id' => Currency::defaultCurrency()->id,
        ]);
    }
}
