<?php

declare(strict_types=1);

namespace Bridge\Database\Seeders;

use Bridge\Domains\Account\Account;
use Bridge\Domains\Member\Member;
use Bridge\Domains\Member\Staff;
use Bridge\Domains\Supplier\Supplier;
use Illuminate\Database\Seeder;
use Illuminate\Support\Str;

class DatabaseSeeder extends Seeder
{
    public function run(): void
    {
        Staff::query()->create([
            'name' => 'Admin',
            'nickname' => null,
            'email' => 'dev@tontri.com',
            'password' => 'password',
        ]);

        Staff::query()->create([
            'name' => 'System',
            'nickname' => null,
            'country' => null,
            'email' => 'system@billing.tld',
            'password' => Str::random(),
        ]);

        if (app()->runningUnitTests()) {
            return;
        }

        Supplier::query()->create([
            'name' => 'JuicyCodes',
            'email' => 'contact@juicycodes.com',
            'country' => 'us',
            'nickname' => 'JUICYCODES',
            'website' => 'https://juicycodes.com',
            'note' => null,
            'address' => null,
        ]);

        if (app()->isProduction()) {
            return;
        }

        $this->call([
            CurrencySeeder::class,
            ItemSeeder::class,
        ]);

        Account::query()->create([
            'name' => 'Cash',
            'currency_id' => 1,
            'bank_name' => '—',
            'identifier' => 'default',
            'is_active' => true,
        ]);

        Member::factory()->customer()->create([
            'name' => 'Tridip',
            'nickname' => null,
            'email' => 'tridip@tontri.com',
        ]);

        Member::factory()->staff()->count(2)->create();
        Member::factory()->customer()->count(3)->create();
    }
}
