<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('notifications', function (Blueprint $table) {
            $table->id();
            $table->morphs('model');
            $table->string('event', 40);
            $table->boolean('should_send')->default(true);
            $table->timestamp('sent_at')->nullable();
            $table->timestamps();

            $table->unique(['model_type', 'model_id', 'event']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('notifications');
    }
};
