<?php

declare(strict_types=1);

use Bridge\Domains\Item\Models\Item;
use Bridge\Domains\Member\Customer;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('item_server_details', function (Blueprint $table) {
            $table->id();
            $table->foreignIdFor(Item::class)
                ->unique()
                ->constrained()
                ->restrictOnUpdate()
                ->restrictOnDelete();

            $table->foreignId('customer_id')
                ->nullable()
                ->constrained(Customer::table())
                ->restrictOnUpdate()
                ->restrictOnDelete();

            $table->string('ip_address');
            $table->unsignedSmallInteger('port');

            $table->date('invoice_date');
            $table->unsignedTinyInteger('due_within');

            $table->text('credentials')->nullable();
            $table->unsignedBigInteger('api_identifier')->nullable();

            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('item_server_details');
    }
};
