<?php

declare(strict_types=1);

use Bridge\Domains\Invoice\Enums\RecurringEndType;
use Bridge\Domains\Invoice\Enums\RecurringFrequency;
use Bridge\Domains\Invoice\Models\Invoice;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('invoice_schedules', function (Blueprint $table) {
            $table->id();
            $table->foreignIdFor(Invoice::class)
                ->constrained()
                ->restrictOnUpdate()
                ->restrictOnDelete();

            $table->enum('frequency', RecurringFrequency::options());
            $table->unsignedInteger('interval')->default(1);
            $table->unsignedInteger('due_within')->default(0);
            $table->date('start_on');
            $table->enum('end_type', RecurringEndType::options());
            $table->date('end_on')->nullable();
            $table->unsignedInteger('end_after')->nullable();

            $table->timestamps();
            $table->softDeletes();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('invoice_schedules');
    }
};
