<?php

declare(strict_types=1);

use Bridge\Domains\Account\Account;
use Bridge\Domains\Currency\Currency;
use Bridge\Domains\Invoice\Models\Invoice;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('invoice_payments', function (Blueprint $table) {
            $table->id();
            $table->foreignIdFor(Invoice::class)
                ->constrained()
                ->restrictOnUpdate()
                ->restrictOnDelete();

            $table->foreignIdFor(Account::class)
                ->constrained()
                ->restrictOnUpdate()
                ->restrictOnDelete();

            $table->foreignIdFor(Currency::class)
                ->constrained()
                ->restrictOnUpdate()
                ->restrictOnDelete();

            $table->string('number', 10)->unique();
            $table->date('paid_on');
            $table->decimal('amount', 10);

            $table->decimal('currency_rate', 10, 4);
            $table->string('notes', 100)->nullable();

            $table->timestamps();
            $table->softDeletes();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('invoice_payments');
    }
};
