<?php

declare(strict_types=1);

use Bridge\Domains\Discount\Enums\DiscountCustomerType;
use Bridge\Domains\Discount\Enums\DiscountStatus;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('discounts', function (Blueprint $table) {
            $table->id();
            $table->string('name', 100);
            $table->string('code', 20)->unique();
            $table->enum('customer_type', DiscountCustomerType::options());
            $table->enum('status', DiscountStatus::options());

            $table->timestamps();
            $table->softDeletes();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('discounts');
    }
};
