<?php

declare(strict_types=1);

use Bridge\Domains\Item\Models\Item;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('item_metas', function (Blueprint $table) {
            $table->id();
            $table->foreignIdFor(Item::class)
                ->constrained()
                ->restrictOnUpdate()
                ->restrictOnDelete();

            $table->string('key', 50);
            $table->string('value', 500)->nullable();

            $table->timestamps();
            $table->unique(['item_id', 'key']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('item_metas');
    }
};
