<?php

declare(strict_types=1);

use Bridge\Domains\Item\Enums\ItemStatus;
use Bridge\Domains\Item\Enums\ItemType;
use Bridge\Domains\Supplier\Supplier;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('items', function (Blueprint $table) {
            $table->id();
            $table->string('name', 100);
            $table->text('note')->nullable();

            $table->foreignIdFor(Supplier::class)
                ->constrained()
                ->restrictOnUpdate()
                ->restrictOnDelete();

            $table->enum('type', ItemType::options());
            $table->enum('status', ItemStatus::options());

            $table->timestamps();
            $table->softDeletes();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('items');
    }
};
