<?php

declare(strict_types=1);

use Bridge\Domains\Currency\Currency;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('accounts', function (Blueprint $table) {
            $table->id();
            $table->string('name', 50);
            $table->string('identifier', 200)->unique();
            $table->string('bank_name', 50);

            $table->foreignIdFor(Currency::class)
                ->constrained()
                ->restrictOnUpdate()
                ->restrictOnDelete();

            $table->decimal('opening_balance', 14, 4)->default(0);
            $table->text('note')->nullable();
            $table->boolean('is_active');
            $table->timestamps();
            $table->softDeletes();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('accounts');
    }
};
