<?php

declare(strict_types=1);

namespace Bridge\Database\Factories;

use Bridge\Domains\Item\Enums\ItemType;
use Bridge\Domains\Service\Service;

/**
 * @extends ItemFactory<Service>
 */
class ServiceFactory extends ItemFactory
{
    protected $model = Service::class;

    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            ...parent::definition(),
            'type' => ItemType::Service->value,
        ];
    }
}
