<?php

declare(strict_types=1);

namespace Bridge\Database\Factories;

use Bridge\Domains\Item\Enums\ItemType;
use Bridge\Domains\Server\Models\ItemServerDetails;
use Bridge\Domains\Server\Models\Server;
use Bridge\Support\RandomNoun;

/**
 * @extends ItemFactory<Server>
 */
class ServerFactory extends ItemFactory
{
    protected $model = Server::class;

    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            ...parent::definition(),
            'name' => $this->generateName(),
            'type' => ItemType::Server->value,
        ];
    }

    public function configure(): static
    {
        return parent::configure()->afterCreating(function (Server $record) {
            ItemServerDetails::factory()->for($record)->create();
        });
    }

    public function metaData(): array
    {
        return [];
    }

    private function generateName(): string
    {
        $prefix = fake()->randomElement(['', 'CORE-', 'ENCODER-', 'STORAGE-']);

        do {
            $name = app()->runningUnitTests()
                ? fake()->domainWord
                : $prefix.RandomNoun::pick();
        } while (strlen($name) < 5);

        return $name;
    }
}
