<?php

declare(strict_types=1);

namespace Bridge\Database\Factories;

use Bridge\Domains\Member\Enums\MemberType;
use Bridge\Domains\Member\Member;
use Bridge\Support\Country;
use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Arr;
use Illuminate\Support\Str;

/**
 * @extends Factory<Member>
 */
class MemberFactory extends Factory
{
    protected $model = Member::class;

    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'name' => $this->faker->name(),
            'email' => $this->faker->unique()->safeEmail(),
            'password' => 'password',

            'nickname' => $this->getNickname(),
            'country' => Arr::random(Country::codes()),
            'note' => fake()->optional(0.2)->sentence(),
            'address' => fake()->optional(0.2)->address(),

            'email_verified_at' => now(),
            'two_factor_secret' => null,
            'two_factor_recovery_codes' => null,
            'remember_token' => Str::random(10),
        ];
    }

    /**
     * @return Factory<Member>
     */
    public function staff(): Factory
    {
        return $this->state(fn () => [
            'type' => MemberType::Staff,
        ]);
    }

    /**
     * @return Factory<Member>
     */
    public function customer(): Factory
    {
        return $this->state(fn () => [
            'type' => MemberType::Customer,
        ]);
    }

    private function getNickname(): ?string
    {
        return fake()->boolean()
            ? null
            : strtoupper(fake()->domainWord());
    }
}
